require("locations/machines.lua");
require("locations/defines.lua");

ingred1 = "blueberry";
ingred2 = "orange";
ingred3 = "saffron";
stripe1 = "stripe_01";
stripe2 = "stripe_11";
stripe3 = "stripe_02";
topping1 = "lemon";
topping2 = "pistachio";
topping3 = "raisins";
novelty = "egg";
infusion1 = "sourcream";
infusion2 = "beets";
infusion3 = "caviar";

kamchatkaStations = {
	
	baseDir = "anim/kamchatka/",
    --------------------------------------------------------------------------------STATION 1
	station_01 = {
		name        = "station01",
		stationType = kCounter,
		stationID   = 1,
		spriteLayer = 2,
		playerPoint = {"station01", kLeft},
		custPoint   = "customer01",
		money       = { 128, 293 },
		
		assets = {
			tabletop = {
				{ state="default", file="stations1_part1", base=0 },
				{ state="upgrade2", file="stations2_part1", base=0 },
				{ state="upgrade1", file="stations3_part1", base=0 },
			},
		},
	},
	--------------------------------------------------------------------------------STATION 2
	station_02 = {
		name        = "station02",
		stationType = kCounter,
		stationID   = 2,
		spriteLayer = 2,
		playerPoint = {"station02", kBack},
		custPoint   = "customer02",
		money       = { 202, 247 },

		assets = {
			tabletop = {
				{ state="default", file="stations1_part1", base=1 },
				{ state="upgrade2", file="stations2_part1", base=1 },
				{ state="upgrade1", file="stations3_part1", base=1 },
			},
		},
	},
	--------------------------------------------------------------------------------STATION 3
	station_03 = {
		name        = "station03",
		stationType = kCounter,
		stationID   = 3,
		spriteLayer = 2,
		playerPoint = {"station03", kBack},
		custPoint   = "customer03",
		money       = { 283, 221 },

		assets = {
			tabletop = {
				{ state="default", file="stations1_part1", base=2 },
				{ state="upgrade2", file="stations2_part1", base=2 },
				{ state="upgrade1", file="stations3_part1", base=2 },
			},
		},
	},
	--------------------------------------------------------------------------------STATION 4
	station_04 = {
		name        = "station04",
		stationType = kCounter,
		stationID   = 4,
		spriteLayer = 2,
		playerPoint = {"station04", kBack},
		custPoint   = "customer04",
		money       = { 372, 209 },

		assets = {
			tabletop = {
				{ state="default", file="stations1_part1", base=3 },
				{ state="upgrade2", file="stations2_part1", base=3 },
				{ state="upgrade1", file="stations3_part1", base=3 },
			},
		},
	},
	--------------------------------------------------------------------------------STATION 5
	station_05 = {
		name        = "station05",
		stationType = kCounter,
		stationID   = 5,		
		spriteLayer = 2,
		playerPoint = {"station05", kBack},
		custPoint   = "customer05",
		money       = { 461, 210 },
		
		assets = {
			tabletop = {
				{ state="default", file="stations1_part1", base=4 },
				{ state="upgrade2", file="stations2_part1", base=4 },
				{ state="upgrade1", file="stations3_part1", base=4 },
			},
		},
	},
	--------------------------------------------------------------------------------STATION 6
	station_06 = {
		name        = "station06",
		stationType = kCounter,
		stationID   = 6,
		spriteLayer = 1,
		playerPoint = {"station06", kBack},
		custPoint   = "customer06",
		money       = { 553, 222 },
		
		assets = {
			tabletop = {
				{ state="default", file="stations1_part1", base=5 },
				{ state="upgrade2", file="stations2_part1", base=5 },
				{ state="upgrade1", file="stations3_part1", base=5 },
			},
		},
	},
	--------------------------------------------------------------------------------STATION 7
	station_07 = {
		name        = "station07",
		stationType = kDelivery,
		stationID   = 7,
		spriteLayer = 2,
		playerPoint = {"station07", kBack},

		assets = {
			tabletop = {
				{ state="default", file="stations1_part1", base=6 },
				{ state="upgrade2", file="stations2_part1", base=6 },
				{ state="upgrade1", file="stations3_part1", base=6 },
			},
		},
		
		machines = {
		    machine_delivery = {
				style = machine_delivery_style,
		    },
		},
	},
	--------------------------------------------------------------------------------STATION 8
	station_08 = {
		name        = "station08",
		stationType = kEmpty,
		stationID   = 8,
		spriteLayer = 2,
		playerPoint = {"station08", kRight},
		
		assets = {
			tabletop = {
				{ state="default", file="stations1_part1", base=7 },
				{ state="upgrade2", file="stations2_part1", base=7 },
				{ state="upgrade1", file="stations3_part1", base=7 },
			},
		},
		machines = {
		    machine_sauce = {
				style	= machine_sauce_style,
		    },
		    machine_sauce_2 = {
		        x		= 30, 
		        y		= 20,
		        style	= machine_sauce_style,
			    name    = "machine_sauce_2",
		    },
		    machine_drink = {
		        x		= 30, 
		        y		= 20,
		        style	= machine_drink_style,
		    },
	    },
	},
	--------------------------------------------------------------------------------STATION 9
	station_09 = {
		name        = "station09",
		stationType = kEmpty,
		stationID   = 9,
		spriteLayer = 2,
		playerPoint = {"station09", kRight},
		
		assets = {
			tabletop = {
				{ state="default", file="stations1_part1", base=8 },
				{ state="upgrade2", file="stations2_part1", base=8 },
				{ state="upgrade1", file="stations3_part1", base=8 },
			},
		},
	},
	--------------------------------------------------------------------------------STATION 10
	station_10 = {
		name        = "station10",
		stationType = kInfuse,
		stationID   = 10,
		spriteLayer = 5,
		playerPoint = {"station10", kRight},

		assets = {
			tabletop = {
				{ state="default", file="stations1_part2", base=0 },
				{ state="upgrade2", file="stations2_part2", base=0 },
				{ state="upgrade1", file="stations3_part2", base=0 },
			},
		},
		
		machines={
		    machine_infusion = {
		        style = machine_infusion_style,
			    --MACHINE SELECTION BUTTONS-----------------------------------
			    selections={
				    button1 = {	
					    baseDir = "anim/machines/buttons/",
					    name    = "btn_infuse_1",
					    x		= 768,
					    y		= 371,
					    id      = 0,
					    icon    = infusion1,
					    assets  = machine_button_assets,
				    },
				    button2 = {	
					    baseDir = "anim/machines/buttons/",
					    name    = "btn_infuse_2",
					    x		= 768,
					    y		= 417,
					    id      = 1,
					    icon    = infusion2,
					    assets  = machine_button_assets,
				    },
				    button3 = {	
					    baseDir = "anim/machines/buttons/",
					    name    = "btn_infuse_3",
					    x		= 768,
					    y		= 462,
					    id      = 2,
					    icon    = infusion3,
					    assets  = machine_button_assets,
				    },
			    },
	        },
		},
	},
	--------------------------------------------------------------------------------STATION 11
	station_11 = {
		name        = "station11",
		stationType = kTopping,
		stationID   = 11,
		spriteLayer = 7,
		playerPoint = {"station11", kFront},
		
		assets = {
			tabletop = {
				{ state="default", file="stations1_part2", base=1 },
				{ state="upgrade2", file="stations2_part2", base=1 },
				{ state="upgrade1", file="stations3_part2", base=1 },
			},
		},
		
		machines = {
		    machine_topping = {
			    style = machine_topping_style,
			    --MACHINE SELECTION BUTTONS-----------------------------------
			    selections={
				    button1 = {	
					    baseDir = "anim/machines/buttons/",
					    name    = "btn_topping_1",
					    id      = 0,
					    x		= 627,
					    y		= 557,
					    icon    = topping1,
					    assets  = machine_button_assets,
				    },
				    button2 = {	
					    baseDir = "anim/machines/buttons/",
					    name    = "btn_topping_2",
					    id      = 1,
					    x		= 671,
					    y		= 543,
					    icon    = topping2,
					    assets  = machine_button_assets,
				    },
				    button3 = {	
					    baseDir = "anim/machines/buttons/",
					    name    = "btn_topping_3",
					    id      = 2,
					    x		= 714,
					    y		= 529,
					    icon    = topping3,
					    assets  = machine_button_assets,
				    },
			    },
		    },
		},
	},
	--------------------------------------------------------------------------------STATION 12
	station_12 = {
		name        = "station12",
		stationType = kBarPress,
		stationID   = 12,
		spriteLayer = 6,
		playerPoint = {"station12", kFront},
		
		assets = {
			tabletop = {
				{ state="default", file="stations1_part2", base=2 },
				{ state="upgrade2", file="stations2_part2", base=2 },
				{ state="upgrade1", file="stations3_part2", base=2 },
			},
		},
		
		machines = {
		    machine_press = {
			    style = machine_press_style,
			    --MACHINE SELECTION BUTTONS-----------------------------------
			    selections = {
				    button1 = {	
					    baseDir = "anim/machines/buttons/",
					    name    = "press_btn_1",
					    id      = 0,
					    x		= 456,
					    y		= 573,
					    icon    = "bar",
					    assets  = machine_button_assets,
				    },
				    button2 = {	
					    baseDir = "anim/machines/buttons/",
					    name    = "press_btn_2",
					    id      = 1,
					    x		= 506,
					    y		= 570,
					    icon    = "truffle",
					    assets  = machine_button_assets,
				    },
				    button3 = {	
					    baseDir = "anim/machines/buttons/",
					    name    = "press_btn_3",
					    id      = 2,
					    x		= 556,
					    y		= 568,
					    icon    = novelty,
					    assets  = machine_button_assets,
				    },
			    },
		    },
		},
	},
	--------------------------------------------------------------------------------STATION 13
	station_13 = {
		name        = "station13",
		stationType = kIngredient,
		stationID   = 13,
		spriteLayer = 6,
		playerPoint = {"station13", kFront},

		assets = {
			tabletop = {
				{ state="default", file="stations1_part2", base=3 },
				{ state="upgrade2", file="stations2_part2", base=3 },
				{ state="upgrade1", file="stations3_part2", base=3 },
			},
		},
		machines = {
		    machine_ingredient = {
				style = machine_ingredient_style,	
			    ------------------------------------------------ MACHINE SELECTION BUTTONS
			    selections = {
				    button1 = {	
					    baseDir = "anim/machines/buttons/",
					    name    = "btn_ingred_1",
					    id      = 0,
					    x		= 257,
					    y		= 562,
					    icon    = ingred1,
					    stripe	= stripe1,
					    assets = machine_button_assets,
				    },
				    button2 = {	
					    baseDir = "anim/machines/buttons/",
					    name    = "btn_ingred_2",
					    id      = 1,
					    x		= 306,
					    y		= 565,
					    icon    = ingred2,
					    stripe	= stripe2,
					    assets = machine_button_assets,
				    },
				    button3 = {	
					    baseDir = "anim/machines/buttons/",
					    name    = "btn_ingred_3",
					    id      = 2,
					    x		= 357,
					    y		= 568,
					    icon    = ingred3,
					    stripe	= stripe3,
					    assets = machine_button_assets,
				    },
			    },
		    },
		},
	},
	--------------------------------------------------------------------------------STATION 14
	station_14 = {
		name        = "station14",
		stationType = kMixer,
		stationID   = 14,
		spriteLayer = 5,
		playerPoint = {"station14", kFront},
		
		assets = {
			tabletop = {
				{ state="default", file="stations1_part2", base=4 },
				{ state="upgrade2", file="stations2_part2", base=4 },
				{ state="upgrade1", file="stations3_part2", base=4 },
			},
		},
		
		machines = {
		    machine_mixer = {
			    style = machine_mixer_style,
			    ------------------------------------------------ MACHINE SELECTION BUTTONS
			    selections={
				    button1 = {
					    baseDir = "anim/machines/buttons/",
					    name    = "btn_mix_dark",
					    id      = 0,
					    x		= 85-10,
					    y		= 518,
					    icon    = "dark",
					    assets	= machine_button_assets,
				    },
				    button2 = {
					    baseDir = "anim/machines/buttons/",
					    name    = "btn_mix_milk",
					    id      = 1,
					    x		= 126-10,
					    y		= 530,
					    icon    = "milk",
					    assets = machine_button_assets,
				    },
				    button3 = {	
					    baseDir = "anim/machines/buttons/",
					    name    = "btn_mix_white",
					    id      = 2,
					    x		= 172-10,
					    y		= 542,
					    icon    = "white",
					    assets = machine_button_assets,
				    },
			    },
		    },
		},
	},
	
	--------------------------------------------------------------------------------DISPOSAL STATION
	station_15 = {
		baseDir     = "anim/machines/disposal/",
		name        = "station15",		
		x           = -10,
		y           = -10,
		stationType = kDisposal,
		stationID   = 15,
		spriteLayer = 3,
		playerPoint = {"station15", kLeft},

		assets = machine_disposal_assets,
		children = machine_disposal_children,
	},
	
	--------------------------------------------------------------------------------DISPLAY CASE STATION
	station_16 = {
		baseDir     = "anim/machines/display/",
		name        = "station16",		
		x           = 412,
		y           = 430,
		stationType = kDisplay,
		stationID   = 15,
		spriteLayer = 3,
		playerPoint = {"station16_north", kFront, "station16_east", kLeft, "station16_west", kRight, "station16_south", kBack},
		
		assets = {
		    base = {
			    { state="default", file="center_table" },
		    },  
		},
	},
	
	-------------------------------------------------------------------------------- CONVEYOR BELT STATION
	station_17 = {
		baseDir     = "anim/machines/conveyor/",
		name        = "station17",		
		stationType = kConveyor,
		stationID   = 17,
		spriteLayer = 3,
		playerPoint = {"station17", kRight},
		
		arcStart = {612,278},
		arcEnd = {103,375},
		arcCenter = {410,790},
		arcVelocity = 5,
		stations = { "station06", {533,247}, 
		             "station05", {457, 237}, 
		             "station04", {375, 236}, 
		             "station03", {297, 246}, 
		             "station02", {225, 269}, 
		             "station01", {166, 306}, 
		             "station15", {145, 329}, 
		             "drop", {103, 326} },
		
		assets = {
		    base = {
                { state="default", file="conveyor_base" },
            }, 
		},
		children = {
		    belt = {
		    layer = -1,
		        mouse = false,
                leaf = false,
		        continuous = true,
		        assets = {
		            base = {
		                { state="default", file="anim_conveyor" },
		            },
		        },
		    },
		},
	},
}